#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// Light OrbitsMod01.fsh   by   ethanbuttimer  
//https://www.shadertoy.com/view/stG3RW
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define PI 3.14159265359

#define BLUR 0.02

//UTILITIES//

float remap01(float a, float b, float t){
    return min(max(0.,(t-a)/(b-a)), 1.);
}

float vecsAngle(vec3 u, vec3 v) {
    return acos(dot(u, v) / (length(u) * length(v)));
}

float DistLine(vec3 ro, vec3 rd, vec3 p) {
    return length(cross(p-ro, rd))/length(rd);
}

//Helper function to correctly blend layers based on depth in scene
vec4 combineZedAlpha(vec4 col1, vec4 col2, float zed1, float zed2){
    if (zed2 < zed1) {
        return vec4(col1.rgb * (1.-col2.a) + col2.rgb, min(1., col1.a + col2.a));
    } else {
        return vec4(col2.rgb * (1.-col1.a) + col1.rgb, min(1., col1.a + col2.a));
    }
}

//DRAWING//

//Circular sprites used to represent point lights
vec3 Point(vec3 ro, vec3 rd, vec3 pos, float rad) {
	float d = DistLine(ro, rd, pos);
    
    float br = smoothstep(rad, rad-BLUR, d);
    float zed = length(pos - ro);
    float alpha = smoothstep(rad, rad-BLUR, d);
    
    return vec3(br, zed, alpha);
}

//Get the surface color of the (warped) sphere resulting from a single light source 
vec3 Sphere(vec3 ro, vec3 rd, vec3 center, float rad, vec3 light) {
    float br = 0.;
    //initialize large depth
    float zed = 1000.;
    float alpha = 0.;
    
    float t = dot(center-ro, rd);
    vec3 p = ro + rd*t;
    
    //Warping
    float blendx = 0.2*(1.+ sin(5.243*iTime));
    p.x = mix(p.x, sin(2.5*p.x), blendx);
    
    float blendy = 0.15*(1.+ sin(7.254*iTime));
    p.y = mix(p.y, sin(2.2*p.y), blendy);
    
    float y = length(center-p);
    
    if (y < rad) {
        float x = sqrt(rad*rad - y*y);
        float t1 = t-x;
        float t2 = t+x;
        
        vec3 camToSurface = rd*t1;
        vec3 p1 = ro + camToSurface;
        
        vec3 norm = normalize(p1 - center);
        vec3 lightRay = normalize(light - p1);
        vec3 viewRay = -normalize(rd);
        vec3 reflRay = normalize(2.* dot(norm, lightRay) * norm - lightRay);//+ for retroreflective
        
        float diff = 1. * max(0.05, dot(lightRay, norm));
        float spec = 0.;
        if (vecsAngle(viewRay, reflRay) < PI/2.) {
            spec = pow(dot(reflRay, viewRay), 4.);
        }
        zed = length(camToSurface);
        alpha = smoothstep(rad, rad-BLUR, y);
        br = 0.5 * (spec+diff) * alpha;
    }

    return vec3(br, zed, alpha);
}

//MAIN//

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{  
    float t = iTime;
    
	vec2 uv =  (fragCoord-iResolution.xy*0.5)/iResolution.y;
    
    //Background gradients
    vec4 backCol = vec4(0.15,0.13,0.2,1.);
    backCol.r += uv.y+0.1-(0.3*cos(1.5*uv.x));
    backCol.g += 0.8*(uv.y-0.1);
    backCol.b += 0.2*uv.y;
    
    //CAMERA MODEL//
    
    //Camera rotates around the sphere
    vec3 ro = vec3(5.*cos(t/2.), 2., 5.*sin(t/2.));
    vec3 lookat = vec3(0.);
    
    float zoom = 1.;
    
    vec3 f = normalize(lookat-ro);
    vec3 r = normalize(cross(vec3(0., 1., 0.), f));
    vec3 u = normalize(cross(f, r));
    
    vec3 c = ro + f*zoom;
    vec3 i = c + uv.x*r + uv.y*u;
    vec3 rd = i-ro;
    
    //OBJECT PLACEMENT//
    
    vec3 spherePos = vec3(0.);//vec3(0., 1.*sin(t), 0.);
    float sphereRad = 1.3 + (0.1 * sin(t*3.13));
    
    float light1OrbitRad = 2.5;// * (1.+ 0.1 * sin(iTime * 5.));
    vec3 light1Pos = vec3(light1OrbitRad*cos(t), 0., light1OrbitRad*sin(t));
    //Brightness changes over time
    vec3 light1Col = vec3(0.9, 0.3, 0.)*(1.+0.8*sin(t));
    
    vec3 light2Pos = vec3(-3., 1.5, 0.);
    vec3 light2Col = vec3(0., 0.9, 0.)*(0.8+0.2*cos(2.3*t));;
    
    float light3OrbitRad = 2.;// * (1.+ 0.1 * sin(iTime * 5.));
    vec3 light3Pos = vec3(0., light3OrbitRad*cos(t*0.5), light3OrbitRad*sin(t*0.5));
    vec3 light3Col = vec3(0., 0., 1.);

    float lightRad = 0.3;
    
    //RENDER LAYERS//
    
    vec3 light1Info = Point(ro, rd, light1Pos, lightRad);
    float light1Zed = light1Info[1];
    vec4 light1Drawn = vec4(light1Col * light1Info[0], light1Info[2]);

    vec3 light2Info = Point(ro, rd, light2Pos, lightRad);
    float light2Zed = light2Info[1];
    vec4 light2Drawn = vec4(light2Col * light2Info[0], light2Info[2]);
    
    vec3 light3Info = Point(ro, rd, light3Pos, lightRad);
    float light3Zed = light3Info[1];
    vec4 light3Drawn = vec4(light3Col * light3Info[0], light3Info[2]);

    vec3 sphereL1Info = Sphere(ro, rd, spherePos, sphereRad, light1Pos);
    vec3 sphereL1Drawn = light1Col * sphereL1Info[0];
    vec3 sphereL2Info = Sphere(ro, rd, spherePos, sphereRad, light2Pos);
    vec3 sphereL2Drawn = light2Col * sphereL2Info[0];
    vec3 sphereL3Info = Sphere(ro, rd, spherePos, sphereRad, light3Pos);
    vec3 sphereL3Drawn = light3Col * sphereL3Info[0];
    float sphereZed = sphereL1Info[1];
    
    //COMBINE LAYERS//
    
    vec4 sphereDrawn = vec4(sphereL1Drawn+sphereL2Drawn+sphereL3Drawn, sphereL1Info[2]);
    
    vec4 retCol = combineZedAlpha(backCol, sphereDrawn, 1000., sphereZed);
    retCol = combineZedAlpha(retCol, light1Drawn, sphereZed, light1Zed);
    retCol = combineZedAlpha(retCol, light2Drawn, sphereZed, light2Zed);
    retCol = combineZedAlpha(retCol, light3Drawn, sphereZed, light3Zed);

	fragColor = retCol;
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

